
function weight_vector = manualWeightsUI()

% Create interface figure
h.weightCI = figure('units', 'normalized', ...
    'Position', [.1, .3, .8, .3]);

%Create controls in figure
h.txtWeight = uicontrol('Style', 'text', ...
    'units', 'normalized', ...
    'Position', [.3, .6, .3, .2], ...
    'String', 'Manually input weight vector', ...
    'FontSize', 20, ...
    'FontWeight', 'bold', ...
    'Tag', 'txtWeight');
h.editWeight = uicontrol('Style', 'edit', ...
    'units', 'normalized', ...
    'Position', [.1, .4, .8, .15], ...
    'String', 'Example: [.1, .03, .07,    .1, .03, .07,    .1, .03, .07,    .1, .03, .07,    .1, .03, .07]', ...
    'Tag', 'editWeight');
h.pbHelpWeight = uicontrol('Style', 'pushbut', ...
    'units', 'normalized', ...
    'Position', [.7, .7, .2, .2], ...
    'String', 'Help', ...
    'Tag', 'pbHelpWeight', ...
    'callback', @helpdialogManualWeight);
h.pbSelectWeight = uicontrol('Style', 'pushbut', ...
    'units', 'normalized', ...
    'Position', [.4, .1, .4, .15], ...
    'String', 'Select weight vector', ...
    'Tag', 'pbSelectWeight', ...
    'callback', 'uiresume(gcbf)');

% Wait for something to happen
uiwait(h.weightCI)

weight_vector = str2num(get(h.editWeight, 'String'))

close(h.weightCI)


function helpdialogManualWeight(~, ~) 
   helpdlg('Insert the weight vector and hit the "Select weight vector" button')
end

end
